function showInfo(image) {
	var rightFrame = parent.right;
	var infoFrame = parent.info;

	if (infoFrame.document.body.offsetHeight == 0) {
		var height = infoFrame.document.body.scrollHeight;
 		rightFrame.rows = "50px, *, " + height + "px";
 		image.setAttribute("title", tipHideInfo);
	}
	else {
		rightFrame.rows = "50px, *, 0";
		image.setAttribute("title", tipShowInfo);
	}
}

function printPage() {
	parent.main.focus();
	setTimeout("parent.main.print();", 0);
}

function changeDocument(menu){
	var url = menu.options[menu.selectedIndex].value;
	if (!url || url == "") return;
	parent.location = url;
}

var helpWin = null;

function displayHelp() {

	if (helpWin == null || helpWin.closed) {
		helpWin = window.showModelessDialog("search_help.htm", window, "resizable: yes; edge: sunken; help: no;");
	}
}

function showOptions(image) {
	var listSelect = parent.list.document.listForm.listSelect;
	var listHeight = 40;

	if (listSelect.disabled) {
		listHeight = 0;
	}

	var options = document.getElementById("search_options");

	if (options.style.display == "") {
		options.style.display = "none";
		image.src = "../common/img/_ShowOptions.gif";
	}
	else {
		options.style.display = "";
		image.src = "../common/img/_HideOptions.gif";
	}

	var search_height = document.body.scrollHeight + 11;
	parent.left.rows = search_height + "px, " + listHeight + "px, *";
}

var recursionCount = 0;

function openPage() {
	var url = top.location.href;
	var hash_params = getHashParams(url);
	if (hash_params == null) return;

	var page = hash_params["page"];
	if (page) {
		recursionCount = 0;
		setMainLocation(page);
	}
}

function setMainLocation(page) {

	if (parent.main == null && recursionCount < 5000) {
		recursionCount++;
		setTimeout("setMainLocation('" + page + "')", 0);
	}
	else {
		parent.main.location.href = "../" + page;
	}
}

function getHashParams(url) {
	var query = getQuery(url);
	if (query == null) return null;

	var arr_params = query.split("&");
	if (arr_params.length < 1) return null;

	var hash_params = {};

	for (var i = 0; i < arr_params.length; i++) {
		var param = arr_params[i];
		var idx = param.indexOf("=");
		if (idx < 1) continue;
		var key = param.substring(0, idx);
		var val = param.substring(idx + 1, param.length);
		hash_params[key] = val;
	}

	return hash_params;
}

function getQuery(url) {
	var idx = url.indexOf("?");
	if (idx < 0 || url.length - 1 <= idx) return null;

	var query = url.substring(idx + 1);
	if (query.length == 0) return null;

	return query;
}

function redirectToIndex(url) {
	var query = getQuery(top.location.href);

	if (query != null && query.length > 0) {
		url += "?" + query;
	}

	location.href = url;
}