var previousPrinted;

function expandOrCollapse(node) {
	var image = node.firstChild;

	if (!image || image.nodeName.toLowerCase() != "img") return;

	var imageId = image.id;
	var contentId = imageId.replace(/_nodeicon$/, "_content");
	var content = top.toc.document.getElementById(contentId);

	if (!content) return;

	var nextSiblingOfContent = getNextSiblingElement(content);

	if (content.style.display == "none") {
		if (nextSiblingOfContent && isLevelClass(nextSiblingOfContent)) {
			image.src = "../common/img/mnode.gif";
		}
		else {
			image.src = "../common/img/mlastnode.gif";
		}
		content.style.display = "";
	}
	else {
		if (nextSiblingOfContent && isLevelClass(nextSiblingOfContent)) {
			image.src = "../common/img/pnode.gif";
		}
		else {
			image.src = "../common/img/plastnode.gif";
		}
		content.style.display = "none";
	}
}

function getNextSiblingElement(node) {
	do {
		node = node.nextSibling;
	} while (node && node.nodeType != 1);

	return node;
}

function isLevelClass(node) {
	return (node && node.className.indexOf("level") > -1);
}

function footPrint(node) {
	highlightTocEntry(node);
	expandContent(node);
}

function highlightTocEntry(node) {
	if (top.toc == null) return;

	if (top.toc.previousPrinted) clearPrint(top.toc.previousPrinted);
	node.style.backgroundColor = "#FFCC66";
	top.toc.previousPrinted = node;
}

function expandContent(node) {
	var tocId = node.id;

	var imageId = tocId + "_nodeicon";
	var image = top.toc.document.getElementById(imageId);

	var contentId = tocId + "_content";
	var content = top.toc.document.getElementById(contentId);

	if (!content || !image || image.nodeName.toLowerCase() != "img") return;

	var nextSiblingOfContent = getNextSiblingElement(content);

	if (content.style.display == "none") {
		if (nextSiblingOfContent && isLevelClass(nextSiblingOfContent)) {
			image.src = "../common/img/mnode.gif";
		}
		else {
			image.src = "../common/img/mlastnode.gif";
		}
		content.style.display = "";
	}
}

function clearPrint(node) {
	node.style.backgroundColor = "";
}

function openToc() {
	var url = top.location.href;
	var hash_params = getHashParams(url);
	if (hash_params == null) return;

	var tocid = hash_params["tocid"];
	if (!tocid) return;

	highlightToc(tocid);
}

function highlightToc(tocid) {
	if (top.toc == null) return;

	var aElement = top.toc.document.getElementById(tocid);
	if (aElement == null) return;

	highlightTocEntry(aElement);
	expandParent(aElement);
	scrollToc(aElement);
}

function expandParent(node) {
	var parent = node.parentNode;
	if (parent == null) return;

	if (parent.className == "content" && parent.style.display == "none") {
		parent.style.display = "";

		var contentId = parent.id;
		var nodeIconId = contentId.replace(/_content/, "_nodeIcon");
		var nodeIconImage = top.toc.document.getElementById(nodeIconId);
		var nextSiblingOfContent = getNextSiblingElement(parent);

		if (nodeIconImage) {
			if (nextSiblingOfContent && isLevelClass(nextSiblingOfContent)){
				nodeIconImage.src = "../common/img/mnode.gif";
			}
			else {
				nodeIconImage.src = "../common/img/mlastnode.gif";
			}
		}
	}

	expandParent(parent);
}

function scrollToc(node) {
	if (top.toc == null) return;

	if (node.parentNode == null || node.parentNode.parentNode == null) return;
	var levelDiv = node.parentNode.parentNode;
	var tocEntryTop = levelDiv.offsetTop;

	var tocPageHeight = top.toc.document.body.offsetHeight;
	var y = tocEntryTop - (tocPageHeight / 2);

	top.toc.scrollTo(0, y);
}